/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.sqlite;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.stream.LongStream;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.engine.SQLOperationsFactoriesBuilder;
import org.codefilarete.stalactite.mapping.id.sequence.SequenceStoredAsTableSelector;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.ServiceLoaderDialectResolver;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.sqlite.SQLiteDMLGenerator;
import org.codefilarete.stalactite.sql.sqlite.SQLiteDialectResolver;
import org.codefilarete.stalactite.sql.sqlite.SQLiteGeneratedKeysReader;
import org.codefilarete.stalactite.sql.sqlite.ddl.SQLiteDDLTableGenerator;
import org.codefilarete.stalactite.sql.sqlite.statement.binder.SQLiteParameterBinderRegistry;
import org.codefilarete.stalactite.sql.sqlite.statement.binder.SQLiteTypeMapping;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.CaseInsensitiveSet;
import org.codefilarete.tool.collection.Sorter;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class SQLiteDatabaseSettings
extends DatabaseVendorSettings {
    public static final String[] KEYWORDS = new String[]{"ABORT", "ACTION", "ADD", "AFTER", "ALL", "ALTER", "ALWAYS", "ANALYZE", "AND", "AS", "ASC", "ATTACH", "AUTOINCREMENT", "BEFORE", "BEGIN", "BETWEEN", "BY", "CASCADE", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "COMMIT", "CONFLICT", "CONSTRAINT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "DATABASE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DETACH", "DISTINCT", "DO", "DROP", "EACH", "ELSE", "END", "ESCAPE", "EXCEPT", "EXCLUDE", "EXCLUSIVE", "EXISTS", "EXPLAIN", "FAIL", "FILTER", "FIRST", "FOLLOWING", "FOR", "FOREIGN", "FROM", "FULL", "GENERATED", "GLOB", "GROUP", "GROUPS", "HAVING", "IF", "IGNORE", "IMMEDIATE", "IN", "INDEX", "INDEXED", "INITIALLY", "INNER", "INSERT", "INSTEAD", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "KEY", "LAST", "LEFT", "LIKE", "LIMIT", "MATCH", "MATERIALIZED", "NATURAL", "NO", "NOT", "NOTHING", "NOTNULL", "NULL", "NULLS", "OF", "OFFSET", "ON", "OR", "ORDER", "OTHERS", "OUTER", "OVER", "PARTITION", "PLAN", "PRAGMA", "PRECEDING", "PRIMARY", "QUERY", "RAISE", "RANGE", "RECURSIVE", "REFERENCES", "REGEXP", "REINDEX", "RELEASE", "RENAME", "REPLACE", "RESTRICT", "RETURNING", "RIGHT", "ROLLBACK", "ROW", "ROWS", "SAVEPOINT", "SELECT", "SET", "TABLE", "TEMP", "TEMPORARY", "THEN", "TIES", "TO", "TRANSACTION", "TRIGGER", "UNBOUNDED", "UNION", "UNIQUE", "UPDATE", "USING", "VACUUM", "VALUES", "VIEW", "VIRTUAL", "WHEN", "WHERE", "WINDOW", "WITH", "WITHOUT"};
    public static final SQLiteDatabaseSettings SQLITE_3_45 = new SQLiteDatabaseSettings();

    private SQLiteDatabaseSettings() {
        this(new SQLiteOperationsFactoriesBuilder(), new SQLiteParameterBinderRegistry());
    }

    private SQLiteDatabaseSettings(SQLiteOperationsFactoriesBuilder sqLiteOperationsFactoriesBuilder, SQLiteParameterBinderRegistry parameterBinderRegistry) {
        super((ServiceLoaderDialectResolver.DatabaseSignet)new SQLiteDialectResolver.SQLiteDatabaseSignet(3, 45), Collections.unmodifiableSet(new CaseInsensitiveSet(KEYWORDS)), '\"', (JavaTypeToSqlTypeMapping)new SQLiteTypeMapping(), (ParameterBinderRegistry)parameterBinderRegistry, (SQLOperationsFactoriesBuilder)sqLiteOperationsFactoriesBuilder, (GeneratedKeysReaderFactory)new SQLiteGeneratedKeysReaderFactory(), 1000, false);
    }

    @VisibleForTesting
    static class SQLiteGeneratedKeysReaderFactory
    implements GeneratedKeysReaderFactory {
        SQLiteGeneratedKeysReaderFactory() {
        }

        public <I> GeneratedKeysReader<I> build(String keyName, Class<I> columnType) {
            return new SQLiteGeneratedKeysReader();
        }
    }

    @VisibleForTesting
    static class SQLiteSequenceSelectorFactory
    implements DatabaseSequenceSelectorFactory {
        private final ReadOperationFactory readOperationFactory;
        private final WriteOperationFactory writeOperationFactory;
        private final DMLGenerator dmlGenerator;

        private SQLiteSequenceSelectorFactory(ReadOperationFactory readOperationFactory, WriteOperationFactory writeOperationFactory, DMLGenerator dmlGenerator) {
            this.dmlGenerator = dmlGenerator;
            this.readOperationFactory = readOperationFactory;
            this.writeOperationFactory = writeOperationFactory;
        }

        public org.codefilarete.tool.function.Sequence<Long> create(Sequence databaseSequence, ConnectionProvider connectionProvider) {
            return new SequenceStoredAsTableSelector(databaseSequence.getSchema(), databaseSequence.getName(), ((Integer)Objects.preventNull((Object)databaseSequence.getInitialValue(), (Object)1)).intValue(), ((Integer)Objects.preventNull((Object)databaseSequence.getBatchSize(), (Object)1)).intValue(), this.dmlGenerator, this.readOperationFactory, this.writeOperationFactory, connectionProvider);
        }
    }

    static class SQLiteWriteOperation<ParamType>
    extends WriteOperation<ParamType> {
        private long updatedRowCount = 0L;

        public SQLiteWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener) {
            super(sqlGenerator, connectionProvider, rowCountListener);
        }

        public long getUpdatedRowCount() {
            return this.updatedRowCount;
        }

        protected long[] doExecuteBatch() throws SQLException {
            long[] rowCounts = super.doExecuteBatch();
            this.updatedRowCount = LongStream.of(rowCounts).sum();
            return rowCounts;
        }
    }

    public static class SQLiteWriteOperationFactory
    extends WriteOperationFactory {
        protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, WriteOperation.RowCountListener rowCountListener) {
            return new SQLiteWriteOperation<ParamType>(sqlGenerator, connectionProvider, rowCountListener){

                protected void prepareStatement(Connection connection) throws SQLException {
                    this.preparedStatement = (PreparedStatement)statementProvider.apply((Object)connection, (Object)this.getSQL());
                }
            };
        }
    }

    private static class SQLiteOperationsFactoriesBuilder
    implements SQLOperationsFactoriesBuilder {
        private final ReadOperationFactory readOperationFactory = new ReadOperationFactory();
        private final SQLiteWriteOperationFactory writeOperationFactory = new SQLiteWriteOperationFactory();

        private SQLiteOperationsFactoriesBuilder() {
        }

        private ReadOperationFactory getReadOperationFactory() {
            return this.readOperationFactory;
        }

        private WriteOperationFactory getWriteOperationFactory() {
            return this.writeOperationFactory;
        }

        public SQLOperationsFactories build(ParameterBinderIndex<Column, ParameterBinder> parameterBinders, DMLNameProviderFactory dmlNameProviderFactory, SqlTypeRegistry sqlTypeRegistry) {
            SQLiteDMLGenerator dmlGenerator = new SQLiteDMLGenerator(parameterBinders, (Sorter<Column>)DMLGenerator.NoopSorter.INSTANCE, dmlNameProviderFactory);
            SQLiteDDLTableGenerator ddlTableGenerator = new SQLiteDDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
            DDLSequenceGenerator ddlSequenceGenerator = new DDLSequenceGenerator(dmlNameProviderFactory);
            return new SQLOperationsFactories((WriteOperationFactory)this.writeOperationFactory, this.readOperationFactory, (DMLGenerator)dmlGenerator, (DDLTableGenerator)ddlTableGenerator, ddlSequenceGenerator, (DatabaseSequenceSelectorFactory)new SQLiteSequenceSelectorFactory(this.readOperationFactory, this.writeOperationFactory, dmlGenerator));
        }
    }
}

